function [ P, J ] = Std_to_Line( L, S )
%Map points of std std [0,1] element onto line. Output the Jacobian.
%   L is a 2 x 2 array with each row the x-y coordinates of the segment's
%   end.  S is a numpt x 1 array giving the std points in question.  J is
%   the jacobian.  Because the transformation is affine linear, 
%   we have the degree of spline class is preserved under pullback 
%   or pushforward.  P is a numpt x 2 array again giving x-y coordinates.
%   The ray is traveled from L(1,:) to L(2,:)

numpt = size(S,1); %Number of points
P = zeros(numpt,2); %For storing images of standard points

for i=1:numpt
    P(i,:) = (1-S(i,1))*L(1,:) + S(i,1)*L(2,:); %Walk the convex line segment
end

%Jacobian is length of L(2,:) - L(1,:) by det(D\sigma, vec{n}) arguments.
V = L(2,:)-L(1,:);
J = sqrt(V*V');
end

